/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event.handlers;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.event.handlers.keymapping.KeyRegistrationWrapper;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.minimap.MiniMap;
import journeymap.client.ui.option.OptionScreen;
import journeymap.client.ui.waypointmanager.WaypointManager;
import journeymap.common.properties.catagory.Category;
import journeymap.common.properties.config.BooleanField;
import journeymap.common.waypoint.WaypointStore;
import net.minecraft.class_11907;
import net.minecraft.class_310;
import net.minecraft.class_437;

public class KeybindingHandler {
    private static KeybindingHandler INSTANCE;
    public KeyRegistrationWrapper kbMapZoomin;
    public KeyRegistrationWrapper kbMapZoomout;
    public KeyRegistrationWrapper kbMapToggleType;
    public KeyRegistrationWrapper kbCreateWaypoint;
    public KeyRegistrationWrapper kbToggleWaypointRendering;
    public KeyRegistrationWrapper kbToggleWaypointWorldRendering;
    public KeyRegistrationWrapper kbToggleWaypointMapRendering;
    public KeyRegistrationWrapper kbToggleWaypoints;
    public KeyRegistrationWrapper kbFullscreenCreateWaypoint;
    public KeyRegistrationWrapper kbFullscreenChatPosition;
    public KeyRegistrationWrapper kbFullscreenToggle;
    public KeyRegistrationWrapper kbWaypointManager;
    public KeyRegistrationWrapper kbMinimapToggle;
    public KeyRegistrationWrapper kbMinimapPreset;
    public KeyRegistrationWrapper kbFullmapOptionsManager;
    public KeyRegistrationWrapper kbFullmapPanNorth;
    public KeyRegistrationWrapper kbFullmapPanSouth;
    public KeyRegistrationWrapper kbFullmapPanEast;
    public KeyRegistrationWrapper kbFullmapPanWest;
    public KeyRegistrationWrapper kbFullmapButtonHide;
    public KeyRegistrationWrapper kbEntityNameDisplay;
    public KeyRegistrationWrapper kbFullmapFollowPlayer;
    private final Map<String, KeyRegistrationWrapper> keyBindings = new HashMap<String, KeyRegistrationWrapper>();
    private final Map<Class<? extends class_437>, List<KeyRegistrationWrapper>> screenBindings = new HashMap<Class<? extends class_437>, List<KeyRegistrationWrapper>>();

    public void registerKeyBinds() {
        this.kbMapZoomin = KeyRegistrationWrapper.builder("key.journeymap.zoom_in", KeyRegistrationWrapper.Context.UNIVERSAL, 61).withAction(() -> MiniMap.state().minimapZoomIn()).addScreenAction(Fullscreen.class, this::inFullscreenWithoutChat, () -> this.getFullscreen().zoomIn()).register();
        this.kbMapZoomout = KeyRegistrationWrapper.builder("key.journeymap.zoom_out", KeyRegistrationWrapper.Context.UNIVERSAL, 45).withAction(() -> MiniMap.state().minimapZoomOut()).addScreenAction(Fullscreen.class, this::inFullscreenWithoutChat, () -> this.getFullscreen().zoomOut()).register();
        this.kbMapToggleType = KeyRegistrationWrapper.builder("key.journeymap.minimap_type", KeyRegistrationWrapper.Context.UNIVERSAL, 91).withAction(() -> MiniMap.state().toggleMapType()).addScreenAction(Fullscreen.class, this::inFullscreenWithoutChat, () -> this.getFullscreen().toggleMapType()).register();
        this.kbMinimapPreset = KeyRegistrationWrapper.builder("key.journeymap.minimap_preset", KeyRegistrationWrapper.Context.IN_GAME, 92).withAction(UIManager.INSTANCE::switchMiniMapPreset).register();
        this.kbCreateWaypoint = KeyRegistrationWrapper.builder("key.journeymap.create_waypoint", KeyRegistrationWrapper.Context.IN_GAME, 66).withAction(() -> UIManager.INSTANCE.openWaypointEditor(null, true)).register();
        this.kbToggleWaypointRendering = KeyRegistrationWrapper.builder("key.journeymap.toggle_render_waypoints", KeyRegistrationWrapper.Context.UNIVERSAL).withAction(WaypointStore::toggleWaypointRendering).addScreenAction(Fullscreen.class, this::inFullscreenWithoutChat, WaypointStore::toggleWaypointRendering).register();
        this.kbToggleWaypointWorldRendering = KeyRegistrationWrapper.builder("key.journeymap.toggle_render_waypoints_world", KeyRegistrationWrapper.Context.IN_GAME).withAction(this::toggleWorldWaypoints).register();
        this.kbToggleWaypointMapRendering = KeyRegistrationWrapper.builder("key.journeymap.toggle_render_waypoints_map", KeyRegistrationWrapper.Context.GUI).addScreenAction(Fullscreen.class, this::inFullscreenWithoutChat, this::toggleMapWaypoints).register();
        this.kbToggleWaypoints = KeyRegistrationWrapper.builder("key.journeymap.toggle_waypoints", KeyRegistrationWrapper.Context.UNIVERSAL).withAction(WaypointStore::toggleAllWaypoints).addScreenAction(Fullscreen.class, this::inFullscreenWithoutChat, WaypointStore::toggleAllWaypoints).register();
        this.kbFullscreenCreateWaypoint = KeyRegistrationWrapper.builder("key.journeymap.fullscreen_create_waypoint", KeyRegistrationWrapper.Context.GUI, 66).addScreenAction(Fullscreen.class, this::inFullscreenWithoutChat, () -> this.getFullscreen().createWaypointAtMouse()).register();
        this.kbFullscreenChatPosition = KeyRegistrationWrapper.builder("key.journeymap.fullscreen_chat_position", KeyRegistrationWrapper.Context.GUI, 67).addScreenAction(Fullscreen.class, this::inFullscreenWithoutChat, () -> this.getFullscreen().chatPositionAtMouse()).register();
        this.kbFullscreenToggle = KeyRegistrationWrapper.builder("key.journeymap.map_toggle_alt", KeyRegistrationWrapper.Context.UNIVERSAL, 74).withAction(UIManager.INSTANCE::getOrOpenFullscreenMap).addScreenAction(Fullscreen.class, this::inFullscreenWithoutChat, UIManager.INSTANCE::closeAll).register();
        this.kbWaypointManager = KeyRegistrationWrapper.builder("key.journeymap.fullscreen_waypoints", KeyRegistrationWrapper.Context.UNIVERSAL, 78).withAction(() -> UIManager.INSTANCE.openWaypointManager(null, null)).addScreenAction(Fullscreen.class, this::inFullscreenWithoutChat, () -> UIManager.INSTANCE.openWaypointManager(null, this.getFullscreen())).addScreenAction(WaypointManager.class, this::inWaypointManager, UIManager.INSTANCE::closeWithKeyBind).register();
        this.kbMinimapToggle = KeyRegistrationWrapper.builder("key.journeymap.minimap_toggle_alt", KeyRegistrationWrapper.Context.IN_GAME, 74).withModifier(KeyRegistrationWrapper.Modifier.CTRL).withFabricKeyCode(77).withAction(UIManager.INSTANCE::toggleMinimap).register();
        this.kbFullmapOptionsManager = KeyRegistrationWrapper.builder("key.journeymap.fullscreen_options", KeyRegistrationWrapper.Context.GUI, 79).addScreenAction(Fullscreen.class, this::inFullscreenWithoutChat, () -> UIManager.INSTANCE.openOptionsManager((class_437)this.getFullscreen(), new Category[0])).addScreenAction(OptionScreen.class, UIManager.INSTANCE::closeWithKeyBind).register();
        this.kbFullmapPanNorth = KeyRegistrationWrapper.builder("key.journeymap.fullscreen.north", KeyRegistrationWrapper.Context.GUI, 265).addScreenAction(Fullscreen.class, this::inFullscreenWithoutChat, () -> this.getFullscreen().moveCanvas(0.0, -16.0)).register();
        this.kbFullmapPanSouth = KeyRegistrationWrapper.builder("key.journeymap.fullscreen.south", KeyRegistrationWrapper.Context.GUI, 264).addScreenAction(Fullscreen.class, this::inFullscreenWithoutChat, () -> this.getFullscreen().moveCanvas(0.0, 16.0)).register();
        this.kbFullmapPanEast = KeyRegistrationWrapper.builder("key.journeymap.fullscreen.east", KeyRegistrationWrapper.Context.GUI, 262).addScreenAction(Fullscreen.class, this::inFullscreenWithoutChat, () -> this.getFullscreen().moveCanvas(16.0, 0.0)).register();
        this.kbFullmapPanWest = KeyRegistrationWrapper.builder("key.journeymap.fullscreen.west", KeyRegistrationWrapper.Context.GUI, 263).addScreenAction(Fullscreen.class, this::inFullscreenWithoutChat, () -> this.getFullscreen().moveCanvas(-16.0, 0.0)).register();
        this.kbFullmapFollowPlayer = KeyRegistrationWrapper.builder("key.journeymap.fullscreen_follow_player", KeyRegistrationWrapper.Context.GUI, 70).addScreenAction(Fullscreen.class, this::inFullscreenWithoutChat, () -> this.getFullscreen().setFollow(true)).register();
        this.kbFullmapButtonHide = KeyRegistrationWrapper.builder("key.journeymap.fullscreen.disable_buttons", KeyRegistrationWrapper.Context.GUI).addScreenAction(Fullscreen.class, this::inFullscreenWithoutChat, () -> this.getFullscreen().hideButtons()).register();
        this.kbEntityNameDisplay = KeyRegistrationWrapper.builder("key.journeymap.toggle_entity_names", KeyRegistrationWrapper.Context.UNIVERSAL, 71).withAction(UIManager.INSTANCE::toggleMiniMapEntityNames).addScreenAction(Fullscreen.class, this::inFullscreenWithoutChat, () -> this.getFullscreen().toggleEntityNames()).register();
    }

    public static KeybindingHandler getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new KeybindingHandler();
        }
        return INSTANCE;
    }

    public Map<String, KeyRegistrationWrapper> getKeyBindings() {
        if (this.keyBindings == null || this.keyBindings.isEmpty()) {
            this.registerKeyBinds();
        }
        return this.keyBindings;
    }

    public KeyRegistrationWrapper register(KeyRegistrationWrapper binding) {
        this.keyBindings.put(binding.description(), binding);
        KeyRegistrationWrapper.Context context = binding.context();
        if (KeyRegistrationWrapper.Context.UNIVERSAL == context || KeyRegistrationWrapper.Context.GUI == context) {
            for (Class<? extends class_437> clz : binding.getScreenBindings().keySet()) {
                List list = this.screenBindings.computeIfAbsent(clz, k -> new ArrayList());
                list.add(binding);
            }
        }
        return binding;
    }

    public boolean consume() {
        for (KeyRegistrationWrapper wrapper : this.keyBindings.values()) {
            boolean ran = false;
            if (wrapper.getKeyBinding() == null || wrapper.context() != KeyRegistrationWrapper.Context.IN_GAME && wrapper.context() != KeyRegistrationWrapper.Context.UNIVERSAL) continue;
            while (wrapper.getKeyBinding().method_1436()) {
                wrapper.action().run();
                ran = true;
            }
            if (!ran) continue;
            return true;
        }
        return false;
    }

    public boolean consume(class_437 screen, class_11907 event) {
        return this.consume(screen.getClass(), event);
    }

    public boolean consume(Class<? extends class_437> clz, class_11907 event) {
        List<KeyRegistrationWrapper> list = this.screenBindings.get(clz);
        if (list != null) {
            for (KeyRegistrationWrapper wrapper : list) {
                if (wrapper.getKeyBinding() == null || !wrapper.matches(event)) continue;
                wrapper.getScreenBindings().get(clz).run();
                return true;
            }
        }
        return false;
    }

    protected Fullscreen getFullscreen() {
        return UIManager.INSTANCE.getOrOpenFullscreenMap();
    }

    private boolean inFullscreenWithoutChat() {
        class_310 mc = class_310.method_1551();
        return mc.field_1755 instanceof Fullscreen && !((Fullscreen)mc.field_1755).isChatOpen() && !((Fullscreen)mc.field_1755).isSearchFocused();
    }

    private boolean inWaypointManager() {
        WaypointManager manager;
        class_310 mc = class_310.method_1551();
        class_437 class_4372 = mc.field_1755;
        return class_4372 instanceof WaypointManager && !(manager = (WaypointManager)class_4372).isSearchFocused();
    }

    private void toggleWorldWaypoints() {
        BooleanField prop;
        prop.set((prop = JourneymapClient.getInstance().getWaypointProperties().renderWaypointsWorld).get() == false);
    }

    private void toggleMapWaypoints() {
        BooleanField prop;
        prop.set((prop = JourneymapClient.getInstance().getWaypointProperties().renderWaypointsMap).get() == false);
    }

    public List<KeyRegistrationWrapper> getInGuiKeybindings() {
        ArrayList<KeyRegistrationWrapper> list = new ArrayList<KeyRegistrationWrapper>();
        for (KeyRegistrationWrapper wrapper : this.keyBindings.values()) {
            if (wrapper.context() != KeyRegistrationWrapper.Context.GUI && wrapper.context() != KeyRegistrationWrapper.Context.UNIVERSAL) continue;
            list.add(wrapper);
        }
        list.sort(Comparator.comparing(kb -> Constants.getString(kb.getKeyBinding().method_1431())));
        return list;
    }
}

